"""Create output parameter

Revision ID: ffe2f57bd288
Revises: 82a0c686152d
Create Date: 2024-03-22 00:10:16.225454+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "ffe2f57bd288"
down_revision: Union[str, None] = "82a0c686152d"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "output_parameters",
        sa.Column("output_parameter_id", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("output_parameter_id"),
    )
    op.create_index(
        op.f("ix_output_parameters_output_parameter_id"),
        "output_parameters",
        ["output_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_output_parameters_workflow_id"),
        "output_parameters",
        ["workflow_id"],
        unique=False,
    )
    op.create_table(
        "workflow_run_output_parameters",
        sa.Column("workflow_run_id", sa.String(), nullable=False),
        sa.Column("output_parameter_id", sa.String(), nullable=False),
        sa.Column("value", sa.JSON(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["output_parameter_id"],
            ["output_parameters.output_parameter_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_run_id"],
            ["workflow_runs.workflow_run_id"],
        ),
        sa.PrimaryKeyConstraint("workflow_run_id", "output_parameter_id"),
    )
    op.create_index(
        op.f("ix_workflow_run_output_parameters_output_parameter_id"),
        "workflow_run_output_parameters",
        ["output_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_workflow_run_output_parameters_workflow_run_id"),
        "workflow_run_output_parameters",
        ["workflow_run_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_workflow_run_output_parameters_workflow_run_id"),
        table_name="workflow_run_output_parameters",
    )
    op.drop_index(
        op.f("ix_workflow_run_output_parameters_output_parameter_id"),
        table_name="workflow_run_output_parameters",
    )
    op.drop_table("workflow_run_output_parameters")
    op.drop_index(op.f("ix_output_parameters_workflow_id"), table_name="output_parameters")
    op.drop_index(op.f("ix_output_parameters_output_parameter_id"), table_name="output_parameters")
    op.drop_table("output_parameters")
    # ### end Alembic commands ###
