"""Create bitwarden credential parameter table

Revision ID: 4630ab8c198e
Revises: ffe2f57bd288
Create Date: 2024-04-03 22:57:03.231654+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "4630ab8c198e"
down_revision: Union[str, None] = "ffe2f57bd288"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "bitwarden_login_credential_parameters",
        sa.Column("bitwarden_login_credential_parameter_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("bitwarden_client_id_aws_secret_key", sa.String(), nullable=False),
        sa.Column("bitwarden_client_secret_aws_secret_key", sa.String(), nullable=False),
        sa.Column("bitwarden_master_password_aws_secret_key", sa.String(), nullable=False),
        sa.Column("url_parameter_key", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("bitwarden_login_credential_parameter_id"),
    )
    op.create_index(
        op.f("ix_bitwarden_login_credential_parameters_bitwarden_login_credential_parameter_id"),
        "bitwarden_login_credential_parameters",
        ["bitwarden_login_credential_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_bitwarden_login_credential_parameters_workflow_id"),
        "bitwarden_login_credential_parameters",
        ["workflow_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_bitwarden_login_credential_parameters_workflow_id"),
        table_name="bitwarden_login_credential_parameters",
    )
    op.drop_index(
        op.f("ix_bitwarden_login_credential_parameters_bitwarden_login_credential_parameter_id"),
        table_name="bitwarden_login_credential_parameters",
    )
    op.drop_table("bitwarden_login_credential_parameters")
    # ### end Alembic commands ###
