"""add domain to organizations table

Revision ID: 24303f1669a7
Revises: 8335d7fecef9
Create Date: 2024-04-23 21:53:45.475199+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "24303f1669a7"
down_revision: Union[str, None] = "8335d7fecef9"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("organizations", sa.Column("domain", sa.String(), nullable=True))
    op.create_index(op.f("ix_organizations_domain"), "organizations", ["domain"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_organizations_domain"), table_name="organizations")
    op.drop_column("organizations", "domain")
    # ### end Alembic commands ###
