"""Add workflow_permanent_id constraint and index to workflows table

Revision ID: baec12642d77
Revises: bf561125112f
Create Date: 2024-05-14 02:45:11.284376+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "baec12642d77"
down_revision: Union[str, None] = "bf561125112f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("workflows", "workflow_permanent_id", existing_type=sa.VARCHAR(), nullable=False)
    op.alter_column("workflows", "version", existing_type=sa.INTEGER(), nullable=False)
    op.create_index(
        op.f("ix_workflows_workflow_permanent_id"),
        "workflows",
        ["workflow_permanent_id"],
        unique=False,
    )
    op.create_index(
        "permanent_id_version_idx",
        "workflows",
        ["workflow_permanent_id", "version"],
        unique=False,
    )
    op.create_unique_constraint(
        "uc_org_permanent_id_version",
        "workflows",
        ["organization_id", "workflow_permanent_id", "version"],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("uc_org_permanent_id_version", "workflows", type_="unique")
    op.drop_index("permanent_id_version_idx", table_name="workflows")
    op.drop_index(op.f("ix_workflows_workflow_permanent_id"), table_name="workflows")
    op.alter_column("workflows", "version", existing_type=sa.INTEGER(), nullable=True)
    op.alter_column("workflows", "workflow_permanent_id", existing_type=sa.VARCHAR(), nullable=True)
    # ### end Alembic commands ###
