"""add proxy_location and webhook_callback_url to workflows table

Revision ID: 04bf06540db6
Revises: baec12642d77
Create Date: 2024-05-16 17:29:55.083124+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "04bf06540db6"
down_revision: Union[str, None] = "baec12642d77"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "workflows",
        sa.Column(
            "proxy_location",
            sa.Enum(
                "US_CA",
                "US_NY",
                "US_TX",
                "US_FL",
                "US_WA",
                "RESIDENTIAL",
                "RESIDENTIAL_ES",
                "NONE",
                name="proxylocation",
            ),
            nullable=True,
        ),
    )
    op.add_column("workflows", sa.Column("webhook_callback_url", sa.String(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("workflows", "webhook_callback_url")
    op.drop_column("workflows", "proxy_location")
    # ### end Alembic commands ###
