"""add task_generations table

Revision ID: 312d305c6b18
Revises: 04bf06540db6
Create Date: 2024-06-07 22:57:18.228793+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "312d305c6b18"
down_revision: Union[str, None] = "04bf06540db6"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "task_generations",
        sa.Column("task_generation_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("user_prompt", sa.String(), nullable=False),
        sa.Column("url", sa.String(), nullable=True),
        sa.Column("navigation_goal", sa.String(), nullable=True),
        sa.Column("navigation_payload", sa.JSON(), nullable=True),
        sa.Column("data_extraction_goal", sa.String(), nullable=True),
        sa.Column("extracted_information_schema", sa.JSON(), nullable=True),
        sa.Column("llm", sa.String(), nullable=True),
        sa.Column("llm_prompt", sa.String(), nullable=True),
        sa.Column("llm_response", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.PrimaryKeyConstraint("task_generation_id"),
    )
    op.create_index(op.f("ix_task_generations_user_prompt"), "task_generations", ["user_prompt"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_task_generations_user_prompt"), table_name="task_generations")
    op.drop_table("task_generations")
    # ### end Alembic commands ###
