"""Create bitwarden identity parameter table

Revision ID: ac679ea03578
Revises: bea545cb21b4
Create Date: 2024-07-11 16:44:54.145819+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "ac679ea03578"
down_revision: Union[str, None] = "bea545cb21b4"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "bitwarden_sensitive_information_parameters",
        sa.Column("bitwarden_sensitive_information_parameter_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("bitwarden_client_id_aws_secret_key", sa.String(), nullable=False),
        sa.Column("bitwarden_client_secret_aws_secret_key", sa.String(), nullable=False),
        sa.Column("bitwarden_master_password_aws_secret_key", sa.String(), nullable=False),
        sa.Column("bitwarden_collection_id", sa.String(), nullable=False),
        sa.Column("bitwarden_identity_key", sa.String(), nullable=False),
        sa.Column("bitwarden_identity_fields", sa.JSON(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("bitwarden_sensitive_information_parameter_id"),
    )
    op.create_index(
        op.f("ix_bitwarden_sensitive_information_parameters_bitwarden_sensitive_information_parameter_id"),
        "bitwarden_sensitive_information_parameters",
        ["bitwarden_sensitive_information_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_bitwarden_sensitive_information_parameters_workflow_id"),
        "bitwarden_sensitive_information_parameters",
        ["workflow_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_bitwarden_sensitive_information_parameters_workflow_id"),
        table_name="bitwarden_sensitive_information_parameters",
    )
    op.drop_index(
        op.f("ix_bitwarden_sensitive_information_parameters_bitwarden_sensitive_information_parameter_id"),
        table_name="bitwarden_sensitive_information_parameters",
    )
    op.drop_table("bitwarden_sensitive_information_parameters")
    # ### end Alembic commands ###
