"""update task_generation table - use user_prompt_hash as the index of a user prompt

Revision ID: 0de9150bc624
Revises: 6de11b2be7c8
Create Date: 2024-09-03 03:56:58.352307+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "0de9150bc624"
down_revision: Union[str, None] = "6de11b2be7c8"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("task_generations", sa.Column("user_prompt_hash", sa.String(), nullable=True))
    op.add_column("task_generations", sa.Column("source_task_generation_id", sa.String(), nullable=True))
    op.drop_index("ix_task_generations_user_prompt", table_name="task_generations")
    op.create_index(
        op.f("ix_task_generations_source_task_generation_id"),
        "task_generations",
        ["source_task_generation_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_task_generations_user_prompt_hash"), "task_generations", ["user_prompt_hash"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_task_generations_user_prompt_hash"), table_name="task_generations")
    op.drop_index(op.f("ix_task_generations_source_task_generation_id"), table_name="task_generations")
    op.create_index("ix_task_generations_user_prompt", "task_generations", ["user_prompt"], unique=False)
    op.drop_column("task_generations", "source_task_generation_id")
    op.drop_column("task_generations", "user_prompt_hash")
    # ### end Alembic commands ###
