"""create totp_codes table and add task.totp_identifier

Revision ID: c5848cc524b1
Revises: c50f0aa0ef24
Create Date: 2024-09-08 21:59:56.666276+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "c5848cc524b1"
down_revision: Union[str, None] = "c50f0aa0ef24"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "totp_codes",
        sa.Column("totp_code_id", sa.String(), nullable=False),
        sa.Column("totp_identifier", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("task_id", sa.String(), nullable=True),
        sa.Column("workflow_id", sa.String(), nullable=True),
        sa.Column("content", sa.String(), nullable=False),
        sa.Column("code", sa.String(), nullable=False),
        sa.Column("source", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("expired_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["tasks.task_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("totp_code_id"),
    )
    op.create_index(op.f("ix_totp_codes_created_at"), "totp_codes", ["created_at"], unique=False)
    op.create_index(op.f("ix_totp_codes_expired_at"), "totp_codes", ["expired_at"], unique=False)
    op.create_index(op.f("ix_totp_codes_totp_identifier"), "totp_codes", ["totp_identifier"], unique=False)
    op.add_column("tasks", sa.Column("totp_identifier", sa.String(), nullable=True))
    op.add_column("workflow_runs", sa.Column("totp_identifier", sa.String(), nullable=True))
    op.add_column("workflows", sa.Column("totp_identifier", sa.String(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("workflows", "totp_identifier")
    op.drop_column("workflow_runs", "totp_identifier")
    op.drop_column("tasks", "totp_identifier")
    op.drop_index(op.f("ix_totp_codes_totp_identifier"), table_name="totp_codes")
    op.drop_index(op.f("ix_totp_codes_expired_at"), table_name="totp_codes")
    op.drop_index(op.f("ix_totp_codes_created_at"), table_name="totp_codes")
    op.drop_table("totp_codes")
    # ### end Alembic commands ###
