"""Introduce workflow_run_blocks

Revision ID: de0254717601
Revises: db41106b9f1a
Create Date: 2024-12-06 01:13:07.932965+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "de0254717601"
down_revision: Union[str, None] = "db41106b9f1a"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "workflow_run_blocks",
        sa.Column("workflow_run_block_id", sa.String(), nullable=False),
        sa.Column("workflow_run_id", sa.String(), nullable=False),
        sa.Column("parent_workflow_run_block_id", sa.String(), nullable=True),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("task_id", sa.String(), nullable=True),
        sa.Column("label", sa.String(), nullable=True),
        sa.Column("block_type", sa.String(), nullable=False),
        sa.Column("status", sa.String(), nullable=False),
        sa.Column("output", sa.JSON(), nullable=True),
        sa.Column("continue_on_failure", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_workflow_run_block_id"],
            ["workflow_run_blocks.workflow_run_block_id"],
        ),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["tasks.task_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_run_id"],
            ["workflow_runs.workflow_run_id"],
        ),
        sa.PrimaryKeyConstraint("workflow_run_block_id"),
    )
    op.create_index("wfrb_org_wfr_index", "workflow_run_blocks", ["organization_id", "workflow_run_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("wfrb_org_wfr_index", table_name="workflow_run_blocks")
    op.drop_table("workflow_run_blocks")
    # ### end Alembic commands ###
