"""Introduce ObserverCruise and ObserverThought. Add workflow_run_block_id and observer_cruise_id to artifacts

Revision ID: 4d51ed4719d5
Revises: de0254717601
Create Date: 2024-12-06 08:52:52.111448+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "4d51ed4719d5"
down_revision: Union[str, None] = "de0254717601"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "observer_cruises",
        sa.Column("observer_cruise_id", sa.String(), nullable=False),
        sa.Column("status", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("workflow_run_id", sa.String(), nullable=True),
        sa.Column("workflow_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_run_id"],
            ["workflow_runs.workflow_run_id"],
        ),
        sa.PrimaryKeyConstraint("observer_cruise_id"),
    )
    op.create_table(
        "observer_thoughts",
        sa.Column("observer_thought_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("observer_cruise_id", sa.String(), nullable=False),
        sa.Column("workflow_run_id", sa.String(), nullable=True),
        sa.Column("workflow_run_block_id", sa.String(), nullable=True),
        sa.Column("workflow_id", sa.String(), nullable=True),
        sa.Column("thought", sa.String(), nullable=True),
        sa.Column("answer", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["observer_cruise_id"],
            ["observer_cruises.observer_cruise_id"],
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.organization_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_run_block_id"],
            ["workflow_run_blocks.workflow_run_block_id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_run_id"],
            ["workflow_runs.workflow_run_id"],
        ),
        sa.PrimaryKeyConstraint("observer_thought_id"),
    )
    op.add_column("artifacts", sa.Column("workflow_run_id", sa.String(), nullable=True))
    op.add_column("artifacts", sa.Column("workflow_run_block_id", sa.String(), nullable=True))
    op.add_column("artifacts", sa.Column("observer_cruise_id", sa.String(), nullable=True))
    op.create_index("org_workflow_run_index", "artifacts", ["organization_id", "workflow_run_id"], unique=False)
    op.create_foreign_key(
        "artifacts_workflow_run_block_id_fkey",
        "artifacts",
        "workflow_run_blocks",
        ["workflow_run_block_id"],
        ["workflow_run_block_id"],
    )
    op.create_foreign_key(
        "artifacts_observer_cruise_id_fkey",
        "artifacts",
        "observer_cruises",
        ["observer_cruise_id"],
        ["observer_cruise_id"],
    )
    op.create_foreign_key(
        "artifacts_workflow_run_id_fkey", "artifacts", "workflow_runs", ["workflow_run_id"], ["workflow_run_id"]
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("artifacts_workflow_run_block_id_fkey", "artifacts", type_="foreignkey")
    op.drop_constraint("artifacts_observer_cruise_id_fkey", "artifacts", type_="foreignkey")
    op.drop_constraint("artifacts_workflow_run_id_fkey", "artifacts", type_="foreignkey")
    op.drop_index("org_workflow_run_index", table_name="artifacts")
    op.drop_column("artifacts", "observer_cruise_id")
    op.drop_column("artifacts", "workflow_run_block_id")
    op.drop_column("artifacts", "workflow_run_id")
    op.drop_table("observer_thoughts")
    op.drop_table("observer_cruises")
    # ### end Alembic commands ###
