"""drop all the foreign keys on artifacts table except for orgnaization_id

Revision ID: 8069e38dc1b4
Revises: fe49b59d836c
Create Date: 2024-12-08 01:31:56.328245+00:00

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "8069e38dc1b4"
down_revision: Union[str, None] = "fe49b59d836c"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index("org_observer_cruise_index", "artifacts", ["organization_id", "observer_cruise_id"], unique=False)
    op.drop_constraint("artifacts_workflow_run_id_fkey", "artifacts", type_="foreignkey")
    op.drop_constraint("artifacts_observer_cruise_id_fkey", "artifacts", type_="foreignkey")
    op.drop_constraint("artifacts_observer_thought_id_fkey", "artifacts", type_="foreignkey")
    op.drop_constraint("artifacts_workflow_run_block_id_fkey", "artifacts", type_="foreignkey")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_foreign_key(
        "artifacts_workflow_run_block_id_fkey",
        "artifacts",
        "workflow_run_blocks",
        ["workflow_run_block_id"],
        ["workflow_run_block_id"],
    )
    op.create_foreign_key(
        "artifacts_observer_thought_id_fkey",
        "artifacts",
        "observer_thoughts",
        ["observer_thought_id"],
        ["observer_thought_id"],
    )
    op.create_foreign_key(
        "artifacts_observer_cruise_id_fkey",
        "artifacts",
        "observer_cruises",
        ["observer_cruise_id"],
        ["observer_cruise_id"],
    )
    op.create_foreign_key(
        "artifacts_workflow_run_id_fkey", "artifacts", "workflow_runs", ["workflow_run_id"], ["workflow_run_id"]
    )
    op.drop_index("org_observer_cruise_index", table_name="artifacts")
    # ### end Alembic commands ###
