"""add more columns for different blocks

Revision ID: 835522a23b19
Revises: cf3cd8d666b0
Create Date: 2024-12-23 19:41:48.849308+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "835522a23b19"
down_revision: Union[str, None] = "cf3cd8d666b0"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index("oc_org_wfr_index", "observer_cruises", ["organization_id", "workflow_run_id"], unique=False)
    op.add_column("workflow_run_blocks", sa.Column("recipients", sa.JSON(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("attachments", sa.JSON(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("subject", sa.String(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("body", sa.String(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("prompt", sa.String(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("wait_sec", sa.Integer(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("workflow_run_blocks", "wait_sec")
    op.drop_column("workflow_run_blocks", "prompt")
    op.drop_column("workflow_run_blocks", "body")
    op.drop_column("workflow_run_blocks", "subject")
    op.drop_column("workflow_run_blocks", "attachments")
    op.drop_column("workflow_run_blocks", "recipients")
    op.drop_index("oc_org_wfr_index", table_name="observer_cruises")
    # ### end Alembic commands ###
