"""observer webhook_callback_url, totp_verification_url, totp_identifier, proxy_location

Revision ID: 46e38fc53f64
Revises: 6a947c379c02
Create Date: 2025-01-14 16:41:46.037751+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "46e38fc53f64"
down_revision: Union[str, None] = "6a947c379c02"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("observer_cruises", sa.Column("webhook_callback_url", sa.String(), nullable=True))
    op.add_column("observer_cruises", sa.Column("totp_verification_url", sa.String(), nullable=True))
    op.add_column("observer_cruises", sa.Column("totp_identifier", sa.String(), nullable=True))
    op.add_column(
        "observer_cruises",
        sa.Column(
            "proxy_location",
            sa.Enum(
                "US_CA",
                "US_NY",
                "US_TX",
                "US_FL",
                "US_WA",
                "RESIDENTIAL",
                "RESIDENTIAL_ES",
                "RESIDENTIAL_IE",
                "RESIDENTIAL_GB",
                "RESIDENTIAL_IN",
                "RESIDENTIAL_JP",
                "RESIDENTIAL_FR",
                "NONE",
                name="proxylocation",
            ),
            nullable=True,
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("observer_cruises", "proxy_location")
    op.drop_column("observer_cruises", "totp_identifier")
    op.drop_column("observer_cruises", "totp_verification_url")
    op.drop_column("observer_cruises", "webhook_callback_url")
    # ### end Alembic commands ###
