"""add block_workflow_run_id to workflow_run_blocks table; add parent_workflow_run_id to workflow_runs table

Revision ID: 3aa0ef96942d
Revises: 957ad2d1d3f7
Create Date: 2025-01-28 08:53:06.357361+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "3aa0ef96942d"
down_revision: Union[str, None] = "957ad2d1d3f7"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("workflow_run_blocks", sa.Column("block_workflow_run_id", sa.String(), nullable=True))
    op.create_foreign_key(None, "workflow_run_blocks", "workflow_runs", ["block_workflow_run_id"], ["workflow_run_id"])
    op.add_column("workflow_runs", sa.Column("parent_workflow_run_id", sa.String(), nullable=True))
    op.create_index(
        op.f("ix_workflow_runs_parent_workflow_run_id"), "workflow_runs", ["parent_workflow_run_id"], unique=False
    )
    op.create_foreign_key(None, "workflow_runs", "workflow_runs", ["parent_workflow_run_id"], ["workflow_run_id"])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "workflow_runs", type_="foreignkey")
    op.drop_index(op.f("ix_workflow_runs_parent_workflow_run_id"), table_name="workflow_runs")
    op.drop_column("workflow_runs", "parent_workflow_run_id")
    op.drop_constraint(None, "workflow_run_blocks", type_="foreignkey")
    op.drop_column("workflow_run_blocks", "block_workflow_run_id")
    # ### end Alembic commands ###
