"""change proxy location enum

Revision ID: ebf093461132
Revises: 5dd8928389c5
Create Date: 2025-02-05 18:39:29.253202+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "ebf093461132"
down_revision: Union[str, None] = "5dd8928389c5"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "observer_cruises",
        "proxy_location",
        existing_type=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        type_=sa.String(),
        existing_nullable=True,
    )
    op.alter_column(
        "tasks",
        "proxy_location",
        existing_type=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        type_=sa.String(),
        existing_nullable=True,
    )
    op.alter_column(
        "workflow_runs",
        "proxy_location",
        existing_type=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        type_=sa.String(),
        existing_nullable=True,
    )
    op.alter_column(
        "workflows",
        "proxy_location",
        existing_type=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        type_=sa.String(),
        existing_nullable=True,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "workflows",
        "proxy_location",
        existing_type=sa.String(),
        type_=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        existing_nullable=True,
    )
    op.alter_column(
        "workflow_runs",
        "proxy_location",
        existing_type=sa.String(),
        type_=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        existing_nullable=True,
    )
    op.alter_column(
        "tasks",
        "proxy_location",
        existing_type=sa.String(),
        type_=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        existing_nullable=True,
    )
    op.alter_column(
        "observer_cruises",
        "proxy_location",
        existing_type=sa.String(),
        type_=postgresql.ENUM(
            "US_CA",
            "US_NY",
            "US_TX",
            "US_FL",
            "US_WA",
            "RESIDENTIAL",
            "NONE",
            "RESIDENTIAL_IE",
            "RESIDENTIAL_GB",
            "RESIDENTIAL_IN",
            "RESIDENTIAL_JP",
            "RESIDENTIAL_DE",
            name="proxylocation",
        ),
        existing_nullable=True,
    )
    # ### end Alembic commands ###
