"""add task_runs

Revision ID: 60d0743274c9
Revises: ebf093461132
Create Date: 2025-02-09 12:26:55.725475+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "60d0743274c9"
down_revision: Union[str, None] = "ebf093461132"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "task_runs",
        sa.Column("task_run_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("task_run_type", sa.String(), nullable=False),
        sa.Column("run_id", sa.String(), nullable=False),
        sa.Column("title", sa.String(), nullable=True),
        sa.Column("url", sa.String(), nullable=True),
        sa.Column("url_hash", sa.String(), nullable=True),
        sa.Column("cached", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("task_run_id"),
    )
    op.create_index("task_run_org_url_index", "task_runs", ["organization_id", "url_hash", "cached"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("task_run_org_url_index", table_name="task_runs")
    op.drop_table("task_runs")
    # ### end Alembic commands ###
