"""Added credentials table and credential parameter

Revision ID: 26c5ed737819
Revises: b111f0f795bd
Create Date: 2025-02-13 15:54:32.388064+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "26c5ed737819"
down_revision: Union[str, None] = "b111f0f795bd"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "credentials",
        sa.Column("credential_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("credential_type", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("website_url", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("credential_id"),
    )
    op.create_table(
        "credential_parameters",
        sa.Column("credential_parameter_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("credential_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflows.workflow_id"],
        ),
        sa.PrimaryKeyConstraint("credential_parameter_id"),
    )
    op.create_index(
        op.f("ix_credential_parameters_credential_parameter_id"),
        "credential_parameters",
        ["credential_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_credential_parameters_workflow_id"), "credential_parameters", ["workflow_id"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_credential_parameters_workflow_id"), table_name="credential_parameters")
    op.drop_index(op.f("ix_credential_parameters_credential_parameter_id"), table_name="credential_parameters")
    op.drop_table("credential_parameters")
    op.drop_table("credentials")
    # ### end Alembic commands ###
