"""change credentials table, add organization_collections table

Revision ID: b4bb0b98912a
Revises: 26c5ed737819
Create Date: 2025-02-20 21:46:23.732969+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "b4bb0b98912a"
down_revision: Union[str, None] = "26c5ed737819"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "organization_bitwarden_collections",
        sa.Column("organization_bitwarden_collection_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("collection_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("organization_bitwarden_collection_id"),
    )
    op.create_index(
        op.f("ix_organization_bitwarden_collections_organization_id"),
        "organization_bitwarden_collections",
        ["organization_id"],
        unique=False,
    )
    op.add_column("credentials", sa.Column("item_id", sa.String(), nullable=True))
    op.drop_column("credentials", "website_url")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("credentials", sa.Column("website_url", sa.VARCHAR(), autoincrement=False, nullable=True))
    op.drop_column("credentials", "item_id")
    op.drop_index(
        op.f("ix_organization_bitwarden_collections_organization_id"), table_name="organization_bitwarden_collections"
    )
    op.drop_table("organization_bitwarden_collections")
    # ### end Alembic commands ###
