"""add index for workflow run and workflow tables

Revision ID: a21b9f4f51d2
Revises: b4bb0b98912a
Create Date: 2025-03-01 04:28:57.760711+00:00

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "a21b9f4f51d2"
down_revision: Union[str, None] = "b4bb0b98912a"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(op.f("ix_steps_task_id"), "steps", ["task_id"], unique=False)
    op.create_index("idx_tasks_org_created", "tasks", ["organization_id", "created_at"], unique=False)
    op.create_index("idx_workflow_runs_org_created", "workflow_runs", ["organization_id", "created_at"], unique=False)
    op.create_index(op.f("ix_workflow_runs_modified_at"), "workflow_runs", ["modified_at"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_workflow_runs_modified_at"), table_name="workflow_runs")
    op.drop_index("idx_workflow_runs_org_created", table_name="workflow_runs")
    op.drop_index("idx_tasks_org_created", table_name="tasks")
    op.drop_index(op.f("ix_steps_task_id"), table_name="steps")
    # ### end Alembic commands ###
