"""add bitwarden_item_id and make url_parameter_key optional in bitwarden_login_credential

Revision ID: 268dcc995513
Revises: a21b9f4f51d2
Create Date: 2025-03-03 16:42:11.868247+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "268dcc995513"
down_revision: Union[str, None] = "a21b9f4f51d2"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("bitwarden_login_credential_parameters", sa.Column("bitwarden_item_id", sa.String(), nullable=True))
    op.alter_column(
        "bitwarden_login_credential_parameters", "url_parameter_key", existing_type=sa.VARCHAR(), nullable=True
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "bitwarden_login_credential_parameters", "url_parameter_key", existing_type=sa.VARCHAR(), nullable=False
    )
    op.drop_column("bitwarden_login_credential_parameters", "bitwarden_item_id")
    # ### end Alembic commands ###
