"""drop most foreign keys

Revision ID: e8285b6ddcf0
Revises: 511d9da18f5d
Create Date: 2025-05-02 11:48:31.191371+00:00

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "e8285b6ddcf0"
down_revision: Union[str, None] = "511d9da18f5d"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("actions_step_id_fkey", "actions", type_="foreignkey")
    op.drop_constraint("actions_task_id_fkey", "actions", type_="foreignkey")
    op.drop_constraint("actions_source_action_id_fkey", "actions", type_="foreignkey")
    op.drop_constraint("actions_workflow_run_id_fkey", "actions", type_="foreignkey")
    op.drop_constraint("actions_organization_id_fkey", "actions", type_="foreignkey")
    op.drop_constraint("artifacts_task_id_fkey", "artifacts", type_="foreignkey")
    op.drop_constraint("artifacts_step_id_fkey", "artifacts", type_="foreignkey")
    op.drop_constraint("aws_secret_parameters_workflow_id_fkey", "aws_secret_parameters", type_="foreignkey")
    op.drop_constraint(
        "bitwarden_credit_card_data_parameters_workflow_id_fkey",
        "bitwarden_credit_card_data_parameters",
        type_="foreignkey",
    )
    op.drop_constraint(
        "bitwarden_login_credential_parameters_workflow_id_fkey",
        "bitwarden_login_credential_parameters",
        type_="foreignkey",
    )
    op.drop_constraint(
        "bitwarden_sensitive_information_parameters_workflow_id_fkey",
        "bitwarden_sensitive_information_parameters",
        type_="foreignkey",
    )
    op.drop_constraint("credential_parameters_workflow_id_fkey", "credential_parameters", type_="foreignkey")
    op.drop_constraint("observer_cruises_workflow_run_id_fkey", "observer_cruises", type_="foreignkey")
    op.drop_constraint("observer_cruises_workflow_id_fkey", "observer_cruises", type_="foreignkey")
    op.drop_constraint("observer_cruises_organization_id_fkey", "observer_cruises", type_="foreignkey")
    op.drop_constraint("observer_thoughts_workflow_run_id_fkey", "observer_thoughts", type_="foreignkey")
    op.drop_constraint("observer_thoughts_workflow_id_fkey", "observer_thoughts", type_="foreignkey")
    op.drop_constraint("observer_thoughts_observer_cruise_id_fkey", "observer_thoughts", type_="foreignkey")
    op.drop_constraint("observer_thoughts_organization_id_fkey", "observer_thoughts", type_="foreignkey")
    op.drop_constraint("observer_thoughts_workflow_run_block_id_fkey", "observer_thoughts", type_="foreignkey")
    op.drop_constraint("output_parameters_workflow_id_fkey", "output_parameters", type_="foreignkey")
    op.drop_constraint(
        "persistent_browser_sessions_organization_id_fkey", "persistent_browser_sessions", type_="foreignkey"
    )
    op.drop_constraint("task_generations_organization_id_fkey", "task_generations", type_="foreignkey")
    op.drop_constraint("workflow_parameters_workflow_id_fkey", "workflow_parameters", type_="foreignkey")
    op.drop_constraint("workflow_run_blocks_task_id_fkey", "workflow_run_blocks", type_="foreignkey")
    op.drop_constraint("workflow_run_blocks_organization_id_fkey", "workflow_run_blocks", type_="foreignkey")
    op.drop_constraint(
        "workflow_run_blocks_parent_workflow_run_block_id_fkey", "workflow_run_blocks", type_="foreignkey"
    )
    op.drop_constraint("workflow_run_blocks_block_workflow_run_id_fkey", "workflow_run_blocks", type_="foreignkey")
    op.drop_constraint("workflow_run_blocks_workflow_run_id_fkey", "workflow_run_blocks", type_="foreignkey")
    op.drop_constraint(
        "workflow_run_output_parameters_output_parameter_id_fkey", "workflow_run_output_parameters", type_="foreignkey"
    )
    op.drop_constraint(
        "workflow_run_output_parameters_workflow_run_id_fkey", "workflow_run_output_parameters", type_="foreignkey"
    )
    op.drop_constraint("workflow_run_parameters_workflow_run_id_fkey", "workflow_run_parameters", type_="foreignkey")
    op.drop_constraint(
        "workflow_run_parameters_workflow_parameter_id_fkey", "workflow_run_parameters", type_="foreignkey"
    )
    op.drop_constraint("workflow_runs_workflow_id_fkey", "workflow_runs", type_="foreignkey")
    op.drop_constraint("fk_workflow_runs_organization_id", "workflow_runs", type_="foreignkey")
    op.drop_constraint("workflow_runs_parent_workflow_run_id_fkey", "workflow_runs", type_="foreignkey")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_foreign_key(
        "workflow_runs_parent_workflow_run_id_fkey",
        "workflow_runs",
        "workflow_runs",
        ["parent_workflow_run_id"],
        ["workflow_run_id"],
    )
    op.create_foreign_key(
        "fk_workflow_runs_organization_id", "workflow_runs", "organizations", ["organization_id"], ["organization_id"]
    )
    op.create_foreign_key(
        "workflow_runs_workflow_id_fkey", "workflow_runs", "workflows", ["workflow_id"], ["workflow_id"]
    )
    op.create_foreign_key(
        "workflow_run_parameters_workflow_parameter_id_fkey",
        "workflow_run_parameters",
        "workflow_parameters",
        ["workflow_parameter_id"],
        ["workflow_parameter_id"],
    )
    op.create_foreign_key(
        "workflow_run_parameters_workflow_run_id_fkey",
        "workflow_run_parameters",
        "workflow_runs",
        ["workflow_run_id"],
        ["workflow_run_id"],
    )
    op.create_foreign_key(
        "workflow_run_output_parameters_workflow_run_id_fkey",
        "workflow_run_output_parameters",
        "workflow_runs",
        ["workflow_run_id"],
        ["workflow_run_id"],
    )
    op.create_foreign_key(
        "workflow_run_output_parameters_output_parameter_id_fkey",
        "workflow_run_output_parameters",
        "output_parameters",
        ["output_parameter_id"],
        ["output_parameter_id"],
    )
    op.create_foreign_key(
        "workflow_run_blocks_workflow_run_id_fkey",
        "workflow_run_blocks",
        "workflow_runs",
        ["workflow_run_id"],
        ["workflow_run_id"],
    )
    op.create_foreign_key(
        "workflow_run_blocks_block_workflow_run_id_fkey",
        "workflow_run_blocks",
        "workflow_runs",
        ["block_workflow_run_id"],
        ["workflow_run_id"],
    )
    op.create_foreign_key(
        "workflow_run_blocks_parent_workflow_run_block_id_fkey",
        "workflow_run_blocks",
        "workflow_run_blocks",
        ["parent_workflow_run_block_id"],
        ["workflow_run_block_id"],
    )
    op.create_foreign_key(
        "workflow_run_blocks_organization_id_fkey",
        "workflow_run_blocks",
        "organizations",
        ["organization_id"],
        ["organization_id"],
    )
    op.create_foreign_key("workflow_run_blocks_task_id_fkey", "workflow_run_blocks", "tasks", ["task_id"], ["task_id"])
    op.create_foreign_key(
        "workflow_parameters_workflow_id_fkey", "workflow_parameters", "workflows", ["workflow_id"], ["workflow_id"]
    )
    op.create_foreign_key(
        "task_generations_organization_id_fkey",
        "task_generations",
        "organizations",
        ["organization_id"],
        ["organization_id"],
    )
    op.create_foreign_key(
        "persistent_browser_sessions_organization_id_fkey",
        "persistent_browser_sessions",
        "organizations",
        ["organization_id"],
        ["organization_id"],
    )
    op.create_foreign_key(
        "output_parameters_workflow_id_fkey", "output_parameters", "workflows", ["workflow_id"], ["workflow_id"]
    )
    op.create_foreign_key(
        "observer_thoughts_workflow_run_block_id_fkey",
        "observer_thoughts",
        "workflow_run_blocks",
        ["workflow_run_block_id"],
        ["workflow_run_block_id"],
    )
    op.create_foreign_key(
        "observer_thoughts_organization_id_fkey",
        "observer_thoughts",
        "organizations",
        ["organization_id"],
        ["organization_id"],
    )
    op.create_foreign_key(
        "observer_thoughts_observer_cruise_id_fkey",
        "observer_thoughts",
        "observer_cruises",
        ["observer_cruise_id"],
        ["observer_cruise_id"],
    )
    op.create_foreign_key(
        "observer_thoughts_workflow_id_fkey", "observer_thoughts", "workflows", ["workflow_id"], ["workflow_id"]
    )
    op.create_foreign_key(
        "observer_thoughts_workflow_run_id_fkey",
        "observer_thoughts",
        "workflow_runs",
        ["workflow_run_id"],
        ["workflow_run_id"],
    )
    op.create_foreign_key(
        "observer_cruises_organization_id_fkey",
        "observer_cruises",
        "organizations",
        ["organization_id"],
        ["organization_id"],
    )
    op.create_foreign_key(
        "observer_cruises_workflow_id_fkey", "observer_cruises", "workflows", ["workflow_id"], ["workflow_id"]
    )
    op.create_foreign_key(
        "observer_cruises_workflow_run_id_fkey",
        "observer_cruises",
        "workflow_runs",
        ["workflow_run_id"],
        ["workflow_run_id"],
    )
    op.create_foreign_key(
        "credential_parameters_workflow_id_fkey", "credential_parameters", "workflows", ["workflow_id"], ["workflow_id"]
    )
    op.create_foreign_key(
        "bitwarden_sensitive_information_parameters_workflow_id_fkey",
        "bitwarden_sensitive_information_parameters",
        "workflows",
        ["workflow_id"],
        ["workflow_id"],
    )
    op.create_foreign_key(
        "bitwarden_login_credential_parameters_workflow_id_fkey",
        "bitwarden_login_credential_parameters",
        "workflows",
        ["workflow_id"],
        ["workflow_id"],
    )
    op.create_foreign_key(
        "bitwarden_credit_card_data_parameters_workflow_id_fkey",
        "bitwarden_credit_card_data_parameters",
        "workflows",
        ["workflow_id"],
        ["workflow_id"],
    )
    op.create_foreign_key(
        "aws_secret_parameters_workflow_id_fkey", "aws_secret_parameters", "workflows", ["workflow_id"], ["workflow_id"]
    )
    op.create_foreign_key("artifacts_step_id_fkey", "artifacts", "steps", ["step_id"], ["step_id"])
    op.create_foreign_key("artifacts_task_id_fkey", "artifacts", "tasks", ["task_id"], ["task_id"])
    op.create_foreign_key(
        "actions_organization_id_fkey", "actions", "organizations", ["organization_id"], ["organization_id"]
    )
    op.create_foreign_key(
        "actions_workflow_run_id_fkey", "actions", "workflow_runs", ["workflow_run_id"], ["workflow_run_id"]
    )
    op.create_foreign_key("actions_source_action_id_fkey", "actions", "actions", ["source_action_id"], ["action_id"])
    op.create_foreign_key("actions_task_id_fkey", "actions", "tasks", ["task_id"], ["task_id"])
    op.create_foreign_key("actions_step_id_fkey", "actions", "steps", ["step_id"], ["step_id"])
    # ### end Alembic commands ###
