"""add started_at and completed_at to the persistent_browser_sessions table

Revision ID: 11b84609ef08
Revises: 07cb499ecbce
Create Date: 2025-05-13 22:10:20.231269+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "11b84609ef08"
down_revision: Union[str, None] = "07cb499ecbce"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("persistent_browser_sessions", sa.Column("timeout_minutes", sa.Integer(), nullable=True))
    op.add_column("persistent_browser_sessions", sa.Column("started_at", sa.DateTime(), nullable=True))
    op.add_column("persistent_browser_sessions", sa.Column("completed_at", sa.DateTime(), nullable=True))
    op.create_index(
        op.f("ix_persistent_browser_sessions_created_at"), "persistent_browser_sessions", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_persistent_browser_sessions_organization_id"),
        "persistent_browser_sessions",
        ["organization_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_persistent_browser_sessions_organization_id"), table_name="persistent_browser_sessions")
    op.drop_index(op.f("ix_persistent_browser_sessions_created_at"), table_name="persistent_browser_sessions")
    op.drop_column("persistent_browser_sessions", "completed_at")
    op.drop_column("persistent_browser_sessions", "started_at")
    op.drop_column("persistent_browser_sessions", "timeout_minutes")
    # ### end Alembic commands ###
