"""remove_include_history_flag_out_of_workflow_run_block

Revision ID: ecdba16ef45c
Revises: d90177b2b935
Create Date: 2025-05-15 19:19:37.737352+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "ecdba16ef45c"
down_revision: Union[str, None] = "d90177b2b935"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        op.f("ix_persistent_browser_sessions_runnable_id"), "persistent_browser_sessions", ["runnable_id"], unique=False
    )
    op.drop_column("workflow_run_blocks", "include_action_history_in_verification")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "workflow_run_blocks",
        sa.Column("include_action_history_in_verification", sa.BOOLEAN(), autoincrement=False, nullable=True),
    )
    op.drop_index(op.f("ix_persistent_browser_sessions_runnable_id"), table_name="persistent_browser_sessions")
    # ### end Alembic commands ###
