"""db script for 1password integration

Revision ID: 1517a4ba63fa
Revises: add_run_timestamps
Create Date: 2025-06-12 08:06:13.439802+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1517a4ba63fa"
down_revision: Union[str, None] = "add_run_timestamps"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "onepassword_credential_parameters",
        sa.Column("onepassword_credential_parameter_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("vault_id", sa.String(), nullable=False),
        sa.Column("item_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("onepassword_credential_parameter_id"),
    )
    op.create_index(
        op.f("ix_onepassword_credential_parameters_onepassword_credential_parameter_id"),
        "onepassword_credential_parameters",
        ["onepassword_credential_parameter_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_onepassword_credential_parameters_workflow_id"),
        "onepassword_credential_parameters",
        ["workflow_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_onepassword_credential_parameters_workflow_id"), table_name="onepassword_credential_parameters"
    )
    op.drop_index(
        op.f("ix_onepassword_credential_parameters_onepassword_credential_parameter_id"),
        table_name="onepassword_credential_parameters",
    )
    op.drop_table("onepassword_credential_parameters")
    # ### end Alembic commands ###
