"""remove unused index on primary key

Revision ID: 2d2f165170f1
Revises: a9fd7a08469c
Create Date: 2025-06-19 20:02:06.061884+00:00

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "2d2f165170f1"
down_revision: Union[str, None] = "a9fd7a08469c"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_actions_action_id", table_name="actions")
    op.drop_index("ix_artifacts_ai_suggestion_id", table_name="artifacts")
    op.drop_index("ix_artifacts_artifact_id", table_name="artifacts")
    op.drop_index("ix_aws_secret_parameters_aws_secret_parameter_id", table_name="aws_secret_parameters")
    op.drop_index("ix_credential_parameters_credential_parameter_id", table_name="credential_parameters")
    op.drop_index(
        "ix_onepassword_credential_parameters_onepassword_creden_aba8", table_name="onepassword_credential_parameters"
    )
    op.drop_index("ix_organizations_organization_id", table_name="organizations")
    op.drop_index("ix_output_parameters_output_parameter_id", table_name="output_parameters")
    op.drop_index("ix_steps_step_id", table_name="steps")
    op.drop_index("ix_tasks_task_id", table_name="tasks")
    op.drop_index("ix_workflow_parameters_workflow_parameter_id", table_name="workflow_parameters")
    op.drop_index("ix_workflow_runs_workflow_run_id", table_name="workflow_runs")
    op.drop_index("ix_workflows_workflow_id", table_name="workflows")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index("ix_workflows_workflow_id", "workflows", ["workflow_id"], unique=False)
    op.create_index("ix_workflow_runs_workflow_run_id", "workflow_runs", ["workflow_run_id"], unique=False)
    op.create_index(
        "ix_workflow_parameters_workflow_parameter_id", "workflow_parameters", ["workflow_parameter_id"], unique=False
    )
    op.create_index("ix_tasks_task_id", "tasks", ["task_id"], unique=False)
    op.create_index("ix_steps_step_id", "steps", ["step_id"], unique=False)
    op.create_index(
        "ix_output_parameters_output_parameter_id", "output_parameters", ["output_parameter_id"], unique=False
    )
    op.create_index("ix_organizations_organization_id", "organizations", ["organization_id"], unique=False)
    op.create_index(
        "ix_onepassword_credential_parameters_onepassword_creden_aba8",
        "onepassword_credential_parameters",
        ["onepassword_credential_parameter_id"],
        unique=False,
    )
    op.create_index(
        "ix_credential_parameters_credential_parameter_id",
        "credential_parameters",
        ["credential_parameter_id"],
        unique=False,
    )
    op.create_index(
        "ix_aws_secret_parameters_aws_secret_parameter_id",
        "aws_secret_parameters",
        ["aws_secret_parameter_id"],
        unique=False,
    )
    op.create_index("ix_artifacts_artifact_id", "artifacts", ["artifact_id"], unique=False)
    op.create_index("ix_artifacts_ai_suggestion_id", "artifacts", ["ai_suggestion_id"], unique=False)
    op.create_index("ix_actions_action_id", "actions", ["action_id"], unique=False)
    # ### end Alembic commands ###
