"""add http request block columns to workflow_run_blocks

Revision ID: 6cf2c1e15039
Revises: 760ae45a1345
Create Date: 2025-06-27 02:11:36.372859+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "6cf2c1e15039"
down_revision: Union[str, None] = "760ae45a1345"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("workflow_run_blocks", sa.Column("http_request_method", sa.String(length=10), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("http_request_url", sa.String(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("http_request_headers", sa.JSON(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("http_request_timeout", sa.Integer(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("http_request_follow_redirects", sa.Boolean(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("http_request_body", sa.JSON(), nullable=True))
    op.add_column("workflow_run_blocks", sa.Column("http_request_parameters", sa.JSON(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("workflow_run_blocks", "http_request_parameters")
    op.drop_column("workflow_run_blocks", "http_request_body")
    op.drop_column("workflow_run_blocks", "http_request_follow_redirects")
    op.drop_column("workflow_run_blocks", "http_request_timeout")
    op.drop_column("workflow_run_blocks", "http_request_headers")
    op.drop_column("workflow_run_blocks", "http_request_url")
    op.drop_column("workflow_run_blocks", "http_request_method")
    # ### end Alembic commands ###
