"""Add debug_sessions table

Revision ID: 044b4a3c3dbc
Revises: 2e997076a3aa
Create Date: 2025-07-28 14:11:17.158184+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "044b4a3c3dbc"
down_revision: Union[str, None] = "2e997076a3aa"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "debug_sessions",
        sa.Column("debug_session_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("browser_session_id", sa.String(), nullable=False),
        sa.Column("workflow_permanent_id", sa.String(), nullable=True),
        sa.Column("user_id", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("debug_session_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("debug_sessions")
    # ### end Alembic commands ###
