"""add projects table

Revision ID: f72cf593e1a7
Revises: 1d0a10ae2a13
Create Date: 2025-07-30 22:49:26.594708+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "f72cf593e1a7"
down_revision: Union[str, None] = "1d0a10ae2a13"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "projects",
        sa.Column("project_revision_id", sa.String(), nullable=False),
        sa.Column("project_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("artifact_id", sa.String(), nullable=True),
        sa.Column("workflow_permanent_id", sa.String(), nullable=True),
        sa.Column("run_id", sa.String(), nullable=True),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("project_revision_id"),
        sa.UniqueConstraint("organization_id", "project_id", "version", name="uc_org_project_version"),
    )
    op.create_index("project_org_created_at_index", "projects", ["organization_id", "created_at"], unique=False)
    op.create_index("project_org_run_id_index", "projects", ["organization_id", "run_id"], unique=False)
    op.create_index("project_org_wpid_index", "projects", ["organization_id", "workflow_permanent_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("project_org_wpid_index", table_name="projects")
    op.drop_index("project_org_run_id_index", table_name="projects")
    op.drop_index("project_org_created_at_index", table_name="projects")
    op.drop_table("projects")
    # ### end Alembic commands ###
