"""add project_files table

Revision ID: 1b2a8b62de61
Revises: 0ecb03206fc6
Create Date: 2025-07-31 16:09:22.454667+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1b2a8b62de61"
down_revision: Union[str, None] = "0ecb03206fc6"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "project_files",
        sa.Column("file_id", sa.String(), nullable=False),
        sa.Column("project_revision_id", sa.String(), nullable=False),
        sa.Column("project_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("file_path", sa.String(), nullable=False),
        sa.Column("file_name", sa.String(), nullable=False),
        sa.Column("file_type", sa.String(), nullable=False),
        sa.Column("content_hash", sa.String(), nullable=True),
        sa.Column("file_size", sa.Integer(), nullable=True),
        sa.Column("mime_type", sa.String(), nullable=True),
        sa.Column("encoding", sa.String(), nullable=True),
        sa.Column("artifact_id", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("file_id"),
        sa.UniqueConstraint("project_revision_id", "file_path", name="unique_project_file_path"),
    )
    op.create_index("file_project_path_index", "project_files", ["project_revision_id", "file_path"], unique=False)
    op.drop_column("projects", "artifact_id")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("projects", sa.Column("artifact_id", sa.VARCHAR(), autoincrement=False, nullable=True))
    op.drop_index("file_project_path_index", table_name="project_files")
    op.drop_table("project_files")
    # ### end Alembic commands ###
