"""Remove workflow_permanent_id from projects table and add project_id to workflows table

Revision ID: 1eedd7a957d1
Revises: 2e58ef1b3d8b
Create Date: 2025-08-01 23:06:18.433869+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1eedd7a957d1"
down_revision: Union[str, None] = "2e58ef1b3d8b"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("project_org_wpid_index"), table_name="projects")
    op.drop_column("projects", "workflow_permanent_id")
    op.add_column("workflows", sa.Column("use_cache", sa.Boolean(), nullable=False, server_default=sa.false()))
    op.execute("UPDATE workflows SET use_cache = FALSE")
    op.alter_column("workflows", "use_cache", server_default=None)
    op.add_column("workflows", sa.Column("cache_project_id", sa.String(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("workflows", "cache_project_id")
    op.drop_column("workflows", "use_cache")
    op.add_column("projects", sa.Column("workflow_permanent_id", sa.VARCHAR(), autoincrement=False, nullable=True))
    op.create_index(
        op.f("project_org_wpid_index"), "projects", ["organization_id", "workflow_permanent_id"], unique=False
    )
    # ### end Alembic commands ###
