"""add_encrypt_token_and_method

Revision ID: dd29417b397c
Revises: 1eedd7a957d1
Create Date: 2025-08-05 04:32:13.735805+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "dd29417b397c"
down_revision: Union[str, None] = "1eedd7a957d1"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("organization_auth_tokens", sa.Column("encrypted_token", sa.String(), nullable=True))
    op.add_column("organization_auth_tokens", sa.Column("encrypted_method", sa.String(), nullable=True))
    op.alter_column("organization_auth_tokens", "token", existing_type=sa.VARCHAR(), nullable=True)
    op.create_index(
        op.f("ix_organization_auth_tokens_encrypted_token"),
        "organization_auth_tokens",
        ["encrypted_token"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_organization_auth_tokens_encrypted_token"), table_name="organization_auth_tokens")
    op.alter_column("organization_auth_tokens", "token", existing_type=sa.VARCHAR(), nullable=False)
    op.drop_column("organization_auth_tokens", "encrypted_method")
    op.drop_column("organization_auth_tokens", "encrypted_token")
    # ### end Alembic commands ###
