"""add  workflow_scripts table

Revision ID: 2fe3e908a028
Revises: f2e78df26c97
Create Date: 2025-08-06 19:46:37.998908+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "2fe3e908a028"
down_revision: Union[str, None] = "f2e78df26c97"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "workflow_scripts",
        sa.Column("workflow_script_id", sa.String(), nullable=False),
        sa.Column("script_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("workflow_permanent_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=True),
        sa.Column("workflow_run_id", sa.String(), nullable=True),
        sa.Column("cache_key", sa.String(), nullable=False),
        sa.Column("cache_key_value", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("workflow_script_id"),
        sa.UniqueConstraint(
            "workflow_permanent_id", "cache_key_value", name="uc_workflow_permanent_id_cache_key_value"
        ),
    )
    op.create_index(
        "idx_workflow_scripts_org_created", "workflow_scripts", ["organization_id", "created_at"], unique=False
    )
    op.create_index(
        "idx_workflow_scripts_workflow_permanent_id", "workflow_scripts", ["workflow_permanent_id"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("idx_workflow_scripts_workflow_permanent_id", table_name="workflow_scripts")
    op.drop_index("idx_workflow_scripts_org_created", table_name="workflow_scripts")
    op.drop_table("workflow_scripts")
    # ### end Alembic commands ###
