"""rename project/projects -> script/scripts

Revision ID: 0135ee8b36b0
Revises: 2fe3e908a028
Create Date: 2025-08-07 04:49:14.257089+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "0135ee8b36b0"
down_revision: Union[str, None] = "2fe3e908a028"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "script_files",
        sa.Column("file_id", sa.String(), nullable=False),
        sa.Column("script_revision_id", sa.String(), nullable=False),
        sa.Column("script_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("file_path", sa.String(), nullable=False),
        sa.Column("file_name", sa.String(), nullable=False),
        sa.Column("file_type", sa.String(), nullable=False),
        sa.Column("content_hash", sa.String(), nullable=True),
        sa.Column("file_size", sa.Integer(), nullable=True),
        sa.Column("mime_type", sa.String(), nullable=True),
        sa.Column("encoding", sa.String(), nullable=True),
        sa.Column("artifact_id", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("file_id"),
        sa.UniqueConstraint("script_revision_id", "file_path", name="unique_script_file_path"),
    )
    op.create_index("file_script_path_index", "script_files", ["script_revision_id", "file_path"], unique=False)
    op.create_table(
        "scripts",
        sa.Column("script_revision_id", sa.String(), nullable=False),
        sa.Column("script_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("run_id", sa.String(), nullable=True),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("script_revision_id"),
        sa.UniqueConstraint("organization_id", "script_id", "version", name="uc_org_script_version"),
    )
    op.create_index("script_org_created_at_index", "scripts", ["organization_id", "created_at"], unique=False)
    op.create_index("script_org_run_id_index", "scripts", ["organization_id", "run_id"], unique=False)
    op.drop_index(op.f("file_project_path_index"), table_name="project_files")
    op.drop_table("project_files")
    op.drop_index(op.f("project_org_created_at_index"), table_name="projects")
    op.drop_index(op.f("project_org_run_id_index"), table_name="projects")
    op.drop_table("projects")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "projects",
        sa.Column("project_revision_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("project_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("organization_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("version", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("created_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
        sa.Column("modified_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
        sa.Column("deleted_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
        sa.Column("run_id", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint("project_revision_id", name=op.f("projects_pkey")),
        sa.UniqueConstraint(
            "organization_id",
            "project_id",
            "version",
            name=op.f("uc_org_project_version"),
            postgresql_include=[],
            postgresql_nulls_not_distinct=False,
        ),
    )
    op.create_index(op.f("project_org_run_id_index"), "projects", ["organization_id", "run_id"], unique=False)
    op.create_index(op.f("project_org_created_at_index"), "projects", ["organization_id", "created_at"], unique=False)
    op.create_table(
        "project_files",
        sa.Column("file_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("project_revision_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("project_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("organization_id", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("file_path", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("file_name", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("file_type", sa.VARCHAR(), autoincrement=False, nullable=False),
        sa.Column("content_hash", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("file_size", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("mime_type", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("encoding", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("artifact_id", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("created_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
        sa.Column("modified_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
        sa.Column("deleted_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint("file_id", name=op.f("project_files_pkey")),
        sa.UniqueConstraint(
            "project_revision_id",
            "file_path",
            name=op.f("unique_project_file_path"),
            postgresql_include=[],
            postgresql_nulls_not_distinct=False,
        ),
    )
    op.create_index(
        op.f("file_project_path_index"), "project_files", ["project_revision_id", "file_path"], unique=False
    )
    op.drop_index("script_org_run_id_index", table_name="scripts")
    op.drop_index("script_org_created_at_index", table_name="scripts")
    op.drop_table("scripts")
    op.drop_index("file_script_path_index", table_name="script_files")
    op.drop_table("script_files")
    # ### end Alembic commands ###
