"""add script_blocks table

Revision ID: 92d665af080e
Revises: d67d7c00ab02
Create Date: 2025-08-08 21:05:52.563372+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "92d665af080e"
down_revision: Union[str, None] = "d67d7c00ab02"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "script_blocks",
        sa.Column("script_block_id", sa.String(), nullable=False),
        sa.Column("script_id", sa.String(), nullable=False),
        sa.Column("script_revision_id", sa.String(), nullable=False),
        sa.Column("script_block_label", sa.String(), nullable=False),
        sa.Column("script_file_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("script_block_id"),
        sa.UniqueConstraint(
            "script_revision_id", "script_block_label", name="uc_script_revision_id_script_block_label"
        ),
    )
    op.create_index(op.f("ix_script_blocks_script_revision_id"), "script_blocks", ["script_revision_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_script_blocks_script_revision_id"), table_name="script_blocks")
    op.drop_table("script_blocks")
    # ### end Alembic commands ###
