"""workflow.use_cache -> generate_script

Revision ID: 944ef972e5a8
Revises: a027553be970
Create Date: 2025-08-10 15:57:46.353038+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "944ef972e5a8"
down_revision: Union[str, None] = "a027553be970"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("workflows", sa.Column("generate_script", sa.Boolean(), nullable=False, server_default=sa.false()))

    # Copy data from use_cache to generate_script
    op.execute("UPDATE workflows SET generate_script = use_cache")

    # Remove server default after data migration
    op.alter_column("workflows", "generate_script", server_default=None)

    # Drop the old use_cache column
    op.drop_column("workflows", "use_cache")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Add back use_cache column
    op.add_column("workflows", sa.Column("use_cache", sa.Boolean(), nullable=False, server_default=sa.false()))

    # Copy data from generate_script back to use_cache
    op.execute("UPDATE workflows SET use_cache = generate_script")

    # Remove server default after data migration
    op.alter_column("workflows", "use_cache", server_default=None)

    # Drop the new generate_script column
    op.drop_column("workflows", "generate_script")
    # ### end Alembic commands ###
