"""remove unique constraints for workflow and script cache_key_value

Revision ID: 1bba8a38ddc7
Revises: f148f36edc09
Create Date: 2025-08-23 01:51:56.114060+00:00

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1bba8a38ddc7"
down_revision: Union[str, None] = "f148f36edc09"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f("uc_workflow_permanent_id_cache_key_value"), "workflow_scripts", type_="unique")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_unique_constraint(
        op.f("uc_workflow_permanent_id_cache_key_value"),
        "workflow_scripts",
        ["workflow_permanent_id", "cache_key_value"],
        postgresql_nulls_not_distinct=False,
    )
    # ### end Alembic commands ###
