"""create azure_vault_credential_parameters table

Revision ID: f78486c3f895
Revises: d15d85a702a4
Create Date: 2025-09-12 16:22:11.988864+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "f78486c3f895"
down_revision: Union[str, None] = "d15d85a702a4"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "azure_vault_credential_parameters",
        sa.Column("azure_vault_credential_parameter_id", sa.String(), nullable=False),
        sa.Column("workflow_id", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("vault_name", sa.String(), nullable=False),
        sa.Column("username_key", sa.String(), nullable=False),
        sa.Column("password_key", sa.String(), nullable=False),
        sa.Column("totp_secret_key", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("modified_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("azure_vault_credential_parameter_id"),
    )
    op.create_index(
        op.f("ix_azure_vault_credential_parameters_workflow_id"),
        "azure_vault_credential_parameters",
        ["workflow_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_azure_vault_credential_parameters_workflow_id"), table_name="azure_vault_credential_parameters"
    )
    op.drop_table("azure_vault_credential_parameters")
    # ### end Alembic commands ###
