"""add status to the workflow_scripts table; update idx_workflow_scripts_wpid_cache_key_value index

Revision ID: 67add341e926
Revises: 8998d998feed
Create Date: 2025-09-17 14:58:20.282185+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "67add341e926"
down_revision: Union[str, None] = "8998d998feed"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("workflow_scripts", sa.Column("status", sa.String(), nullable=True, server_default="published"))
    op.drop_index(op.f("idx_workflow_scripts_wpid_cache_key_value"), table_name="workflow_scripts")
    op.create_index(
        "idx_workflow_scripts_wpid_cache_key_value",
        "workflow_scripts",
        ["workflow_permanent_id", "cache_key_value", "workflow_run_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("idx_workflow_scripts_wpid_cache_key_value", table_name="workflow_scripts")
    op.create_index(
        op.f("idx_workflow_scripts_wpid_cache_key_value"),
        "workflow_scripts",
        ["workflow_permanent_id", "cache_key_value"],
        unique=False,
    )
    op.drop_column("workflow_scripts", "status")
    # ### end Alembic commands ###
