"""add created_at index for multiple tables

Revision ID: e0ccabc005af
Revises: 4925c34e8d58
Create Date: 2025-09-25 15:03:25.567938+00:00

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "e0ccabc005af"
down_revision: Union[str, None] = "4925c34e8d58"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        "ix_observer_cruises_org_created_at", "observer_cruises", ["organization_id", "created_at"], unique=False
    )
    op.create_index(
        "ix_observer_thoughts_org_created_at", "observer_thoughts", ["organization_id", "created_at"], unique=False
    )
    op.create_index("ix_task_runs_org_created_at", "task_runs", ["organization_id", "created_at"], unique=False)
    op.create_index("ix_totp_codes_org_created_at", "totp_codes", ["organization_id", "created_at"], unique=False)
    op.create_index(
        "ix_workflow_run_blocks_org_created_at", "workflow_run_blocks", ["organization_id", "created_at"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_workflow_run_blocks_org_created_at", table_name="workflow_run_blocks")
    op.drop_index("ix_totp_codes_org_created_at", table_name="totp_codes")
    op.drop_index("ix_task_runs_org_created_at", table_name="task_runs")
    op.drop_index("ix_observer_thoughts_org_created_at", table_name="observer_thoughts")
    op.drop_index("ix_observer_cruises_org_created_at", table_name="observer_cruises")
    # ### end Alembic commands ###
