"""add_totp_type_to_credentials

Revision ID: 8d015c5358f8
Revises: 81351201bc8d
Create Date: 2025-10-08 18:22:45.893853+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "8d015c5358f8"
down_revision: Union[str, None] = "81351201bc8d"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Add column as nullable initially
    op.add_column("credentials", sa.Column("totp_type", sa.String(), nullable=True))

    # Set default value for existing records
    op.execute("UPDATE credentials SET totp_type = 'none' WHERE totp_type IS NULL")

    # Make column non-nullable with default value
    op.alter_column("credentials", "totp_type", nullable=False, server_default="none")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("credentials", "totp_type")
    # ### end Alembic commands ###
