"""add job id idx

Revision ID: 7cd6f55be8d2
Revises: 8d015c5358f8
Create Date: 2025-10-09 08:27:14.047236+00:00

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "7cd6f55be8d2"
down_revision: Union[str, None] = "8d015c5358f8"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.get_context().autocommit_block():
        op.execute("SET statement_timeout = '3h';")
        op.execute("""
            CREATE INDEX CONCURRENTLY IF NOT EXISTS ix_workflow_runs_job_id 
            ON workflow_runs (job_id);
        """)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.get_context().autocommit_block():
        op.execute("DROP INDEX IF EXISTS ix_workflow_runs_job_id;")
    # ### end Alembic commands ###
