"""Creds in Azure Vault

Revision ID: d648e2df239e
Revises: 7cd6f55be8d2
Create Date: 2025-10-10 15:33:02.700316+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "d648e2df239e"
down_revision: Union[str, None] = "7cd6f55be8d2"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("credentials", sa.Column("vault_type", sa.String(), nullable=True))
    op.add_column("credentials", sa.Column("username", sa.String(), nullable=True))
    op.add_column("credentials", sa.Column("totp_identifier", sa.String(), nullable=True))
    op.add_column("credentials", sa.Column("card_last4", sa.String(), nullable=True))
    op.add_column("credentials", sa.Column("card_brand", sa.String(), nullable=True))
    op.add_column("organization_bitwarden_collections", sa.Column("deleted_at", sa.DateTime(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("organization_bitwarden_collections", "deleted_at")
    op.drop_column("credentials", "card_brand")
    op.drop_column("credentials", "card_last4")
    op.drop_column("credentials", "totp_identifier")
    op.drop_column("credentials", "username")
    op.drop_column("credentials", "vault_type")
    # ### end Alembic commands ###
