"""add magic link type otp

Revision ID: 774e10939484
Revises: d648e2df239e
Create Date: 2025-10-14 08:19:23.888067+00:00

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "774e10939484"
down_revision: Union[str, None] = "d648e2df239e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("totp_codes", sa.Column("otp_type", sa.String(), server_default=sa.text("'totp'"), nullable=True))
    op.create_index("ix_totp_codes_otp_type", "totp_codes", ["organization_id", "otp_type"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_totp_codes_otp_type", table_name="totp_codes")
    op.drop_column("totp_codes", "otp_type")
    # ### end Alembic commands ###
