type Props = {
  className?: string;
};

function BugIcon({ className }: Props) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      className={className}
    >
      <path
        clipRule="evenodd"
        fill="currentColor"
        fillRule="evenodd"
        d="M7.293 3.293a1 1 0 0 1 1.414 0l1.876 1.876A6.39 6.39 0 0 1 12 5c.515 0 .996.049 1.445.14l1.848-1.847a1 1 0 1 1 1.414 1.414L15.45 5.965A5.5 5.5 0 0 1 17.249 8H18c.173 0 .456-.06.666-.212.159-.114.334-.314.334-.788a1 1 0 1 1 2 0c0 1.126-.491 1.926-1.166 2.412A3.233 3.233 0 0 1 18 10h-.086c.06.36.086.7.086 1v1h2a1 1 0 1 1 0 2h-2v1c0 .3-.026.64-.086 1H18c.493 0 1.211.14 1.834.588C20.51 17.075 21 17.875 21 19a1 1 0 1 1-2 0c0-.474-.175-.674-.334-.788A1.239 1.239 0 0 0 18 18h-.751a5.537 5.537 0 0 1-1.552 1.857C14.766 20.563 13.543 21 12 21c-1.543 0-2.765-.437-3.697-1.143-.7-.53-1.2-1.188-1.552-1.857H6c-.173 0-.456.06-.666.212-.159.114-.334.314-.334.788a1 1 0 1 1-2 0c0-1.126.492-1.926 1.166-2.412A3.233 3.233 0 0 1 6 16h.086c-.06-.36-.086-.7-.086-1v-1H4a1 1 0 1 1 0-2h2v-1c0-.349.022-.682.065-1H6c-.493 0-1.211-.14-1.834-.588C3.492 8.926 3 8.126 3 7a1 1 0 0 1 2 0c0 .474.175.674.334.788.21.152.493.212.666.212h.696A5.34 5.34 0 0 1 8.58 5.994L7.293 4.707a1 1 0 0 1 0-1.414zM12 9a1 1 0 1 0 0 2h.001a1 1 0 1 0 0-2H12zm-3 4a1 1 0 0 1 1-1h.001a1 1 0 1 1 0 2H10a1 1 0 0 1-1-1zm5-1a1 1 0 1 0 0 2h.001a1 1 0 1 0 0-2H14z"
      />
    </svg>
  );
}

export { BugIcon };
