# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .file_info import FileInfo
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class BrowserSessionResponse(UniversalBaseModel):
    """
    Response model for browser session information.
    """

    browser_session_id: str = pydantic.Field()
    """
    Unique identifier for the browser session. browser_session_id starts with `pbs_`.
    """

    organization_id: str = pydantic.Field()
    """
    ID of the organization that owns this session
    """

    runnable_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of the current runnable associated with this session (workflow, task etc)
    """

    runnable_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the current runnable
    """

    timeout: typing.Optional[int] = pydantic.Field(default=None)
    """
    Timeout in minutes for the session. Timeout is applied after the session is started. Defaults to 60 minutes.
    """

    browser_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    Url for connecting to the browser
    """

    app_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Url for the browser session page
    """

    vnc_streaming_supported: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the browser session supports VNC streaming
    """

    download_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The path where the browser session downloads files
    """

    downloaded_files: typing.Optional[typing.List[FileInfo]] = pydantic.Field(default=None)
    """
    The list of files downloaded by the browser session
    """

    recordings: typing.Optional[typing.List[FileInfo]] = pydantic.Field(default=None)
    """
    The list of video recordings from the browser session
    """

    started_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the session was started
    """

    completed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the session was completed
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the session was created (the timestamp for the initial request)
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the session was last modified
    """

    deleted_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the session was deleted, if applicable
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
