# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.pydantic_utilities import update_forward_refs


class FileNode(UniversalBaseModel):
    """
    Model representing a file or directory in the file tree.
    """

    type: str = pydantic.Field()
    """
    Type of node: 'file' or 'directory'
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    File size in bytes
    """

    mime_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    MIME type of the file
    """

    content_hash: typing.Optional[str] = pydantic.Field(default=None)
    """
    SHA256 hash of file content
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the file was created
    """

    children: typing.Optional[typing.Dict[str, typing.Optional["FileNode"]]] = pydantic.Field(default=None)
    """
    Child nodes for directories
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(FileNode)
