# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class NonEmptyCreditCardCredential(UniversalBaseModel):
    """
    Credit card credential model that requires non-empty values.
    """

    card_number: str = pydantic.Field()
    """
    The full credit card number (must not be empty)
    """

    card_cvv: str = pydantic.Field()
    """
    The card's CVV (must not be empty)
    """

    card_exp_month: str = pydantic.Field()
    """
    The card's expiration month (must not be empty)
    """

    card_exp_year: str = pydantic.Field()
    """
    The card's expiration year (must not be empty)
    """

    card_brand: str = pydantic.Field()
    """
    The card's brand (must not be empty)
    """

    card_holder_name: str = pydantic.Field()
    """
    The name of the card holder (must not be empty)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
