# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .totp_type import TotpType
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class PasswordCredentialResponse(UniversalBaseModel):
    """
    Response model for password credentials, containing only the username.
    """

    username: str = pydantic.Field()
    """
    The username associated with the credential
    """

    totp_type: typing.Optional[TotpType] = pydantic.Field(default=None)
    """
    Type of 2FA method used for this credential
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
