# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Script(UniversalBaseModel):
    script_revision_id: str = pydantic.Field()
    """
    Unique identifier for this specific script revision
    """

    script_id: str = pydantic.Field()
    """
    User-facing script identifier, consistent across versions
    """

    organization_id: str = pydantic.Field()
    """
    ID of the organization that owns this script
    """

    run_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the workflow run or task run that generated this script
    """

    version: int = pydantic.Field()
    """
    Version number of the script
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the script was created
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the script was last modified
    """

    deleted_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the script was soft deleted
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
